class customDesignerFunctions { }

customDesignerFunctions.saveAs = function (blob, fileName, allowAll) {
  var reader = new FileReader();
  reader.readAsDataURL(blob);
  reader.onloadend = function () {
    let content = reader.result.substr(reader.result.indexOf(',') + 1);
    $4d._vp_saveFile(content, fileName, allowAll, function (ret, err) { });
  }
}

customDesignerFunctions.computePdfFonts = function (sheetIndex, callback) {
  Utils.computePdfFonts(sheetIndex, callback);
}

customDesignerFunctions.localizedCommandList = function (list) {
  let mapping = GC.Spread.CalcEngine.getMapping();

  if (mapping != null) {
    let mapper = mapping.builtInFunctionsMapping;

    list.forEach(i => {
      if ((i.value in mapper) && ('alias' in mapper[i.value])) {
        i.text = mapper[i.value].alias
      }
    });
  }

  list.sort(function (a, b) {
    return a.text.localeCompare(b.text);
  });

  return list;
}

customDesignerFunctions.localizedCommandName = function (name, lower) {
  let mapping = GC.Spread.CalcEngine.getMapping();

  name = name.toUpperCase();

  if (mapping != null) {
    let mapper = mapping.builtInFunctionsMapping;

    if (name in mapper) {
      name = mapper[name].alias
    }
  }

  if (lower) {
    name = name.charAt(0).toUpperCase() + name.slice(1).toLowerCase();
  }

  return name;
}

customDesignerFunctions.spreadFrom4vp = function (data) {
  if ((data != null) && (typeof data === "object") && ("spreadJS" in data)) {
    vp_resetOptimizer();
    return data.spreadJS;
  } else return null;
}

customDesignerFunctions.spreadTo4vp = function (data) {
  Utils.addFormatedText(data);
  var vpFile = {};
  vpFile.version = 1;
  var d = new Date;
  vpFile.dateCreation = d.toISOString();
  vpFile.dateModified = d.toISOString();
  vpFile.spreadJS = data;
  return vpFile;
}

customDesignerFunctions.notifyReady = function () {
  $(".loading-placeholder").addClass('hidden');
  designerReady = true;
}

customDesignerFunctions.print = function (context, options) {
  var sheetIndex;
  if (options.printSetting && options.printSetting.sheetToPrint && options.printSetting.sheetToPrint.selectedValue !== undefined) {
    sheetIndex = +options.printSetting.sheetToPrint.selectedValue;
  }
  context.Spread.print(sheetIndex);
}

customDesignerFunctions.initEvents = function (newSpread) {
  spread = newSpread;
  Utils.initEvents();
  Utils.initCommands();
}

customDesignerFunctions.getCustomFunctionsList = function () {
  let list = Utils.customFunctionNames;
  list.sort();
  return list.map(r => {
    return {
      text: r,
      value: r
    };
  });
}

customDesignerFunctions.fillWithArraySystemFonts = function () {
  return vp_fonts.map(val => { return { text: val, value: val }; });
}

customDesignerFunctions.fillWithTruncatedArraySystemFonts = function () {
  return vp_fonts.map(val => {
    let value = val.replace(/"/g, '');
    return { text: value, value: val };
  });
}


customDesignerFunctions.init = function () {
  let moduleFormulaMore = exported_modules.c["./src/commands/ribbon/formulas/functions/formulaMore/formulaMore.ts"].exports;
  moduleFormulaMore.FormulaMore.dropdownList[5].subItems = customDesignerFunctions.getCustomFunctionsList();

  let moduleSupportedFunctions = exported_modules.c["./src/commands/ribbon/formulas/functions/supportedFunctions/supportedFunctions.ts"].exports;
  moduleSupportedFunctions.allFunctionItems = moduleSupportedFunctions.allFunctionItems.concat(customDesignerFunctions.getCustomFunctionsList());
  moduleSupportedFunctions.allFunctionItems.sort(function (a, b) {
    return a.text.localeCompare(b.text);
  });

  let moduleInsertFunctionDialog = exported_modules.c["./src/commands/ribbon/formulas/functionHandler/insertFunctionDialog.tpl.ts"].exports;
  moduleInsertFunctionDialog.insertFunctionDialogTemplate.content[0].children[0].children[1].children[1].children[12].items = customDesignerFunctions.getCustomFunctionsList();
  moduleInsertFunctionDialog.insertFunctionDialogTemplate.content[0].children[0].children[1].children[1].children[0].items = moduleSupportedFunctions.allFunctionItems;

  // customize fonts
  if (vp_fonts.length > 0) {
    let moduleHeaderCellFontDialog = exported_modules.c["./src/commands/contextmenu/colheader/headerCellDialog/headerCellEditor/FontDialogEditor/fontDialogEditor.ts"].exports;
    moduleHeaderCellFontDialog.fontDialogTemplate.content[0].children[0].children[0].children[1].items = customDesignerFunctions.fillWithTruncatedArraySystemFonts(); // [{text:"toto",value:"toto"}];

    let moduleFormatCommentDialog = exported_modules.c["./src/commands/contextmenu/viewportcorner/formatComment/formatCommentDialog.tpl.ts"].exports;
    moduleFormatCommentDialog.formatCommentDialogTemplate.content[0].children[0].children[0].children[0].children[0].children[1].items = customDesignerFunctions.fillWithTruncatedArraySystemFonts();

    let moduleFormatDialog = exported_modules.c["./src/commands/formatDialog/formatDialog.tpl.ts"].exports;
    moduleFormatDialog.formatDialogTemplate.content[0].children[2].children[0].children[0].children[0].children[1].items = customDesignerFunctions.fillWithTruncatedArraySystemFonts();

    let moduleFontPicker = exported_modules.c["./src/components/compositeComponents/font/fontpicker.tpl.ts"].exports;
    moduleFontPicker.fontPicker.children[0].children[0].children[0].items = customDesignerFunctions.fillWithTruncatedArraySystemFonts();

    let moduleFontFamily = exported_modules.c["./src/commands/ribbon/home/fonts/fontFamily/fontFamily.ts"].exports;
    moduleFontFamily.FontFamily.resetFonts();
  }

}


customDesignerFunctions.initDesignerCommands = function () {
  var commandManager = spread.commandManager();
  commandManager.register("DesignerInsertRowPageBreak", config.commandMap.DesignerInsertRowPageBreak, undefined, false, false, false, false);
  commandManager.register("DesignerRemoveRowPageBreak", config.commandMap.DesignerRemoveRowPageBreak, undefined, false, false, false, false);
  commandManager.register("DesignerInsertColPageBreak", config.commandMap.DesignerInsertColPageBreak, undefined, false, false, false, false);
  commandManager.register("DesignerRemoveColPageBreak", config.commandMap.DesignerRemoveColPageBreak, undefined, false, false, false, false);
  commandManager.register("DesignerInsertPageBreak", config.commandMap.DesignerInsertPageBreak, undefined, false, false, false, false);
  commandManager.register("DesignerRemovePageBreak", config.commandMap.DesignerRemovePageBreak, undefined, false, false, false, false);
}